using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmInvalidateFinalStatus
	/// </summary>
	public class FrmInvalidateFinalStatus : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.BloodUnit _bloodUnit;
		private BOL.BloodUnit _previousUnit;
		private string _previousUnitStatus = "";
		private Common.UnitStatusCode _previousUnitStatusCode = Common.UnitStatusCode.Unknown;
		private DataRow _bloodUnitModification;
		private DataTable _dtComments;
		private bool _detailsRequired = false;
		private BOL.PatientTransfusion _patientTransfusion;
				
		#endregion

		#region FormControls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.Label lblWarning;
		private System.Windows.Forms.Button btnClose;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblDetails;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private System.Windows.Forms.GroupBox grpComments;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.TextBox txtDetails;
		private System.Windows.Forms.GroupBox grpCurrent;
		private System.Windows.Forms.GroupBox grpPrevious;
		private System.Windows.Forms.TextBox txtCurrentStatus;
		private System.Windows.Forms.Label lblCurrentStatus;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.TextBox txtPreviousProduct;
		private System.Windows.Forms.Label lblPreviousProduct;
		private System.Windows.Forms.TextBox txtPreviousExpiration;
		private System.Windows.Forms.Label lblPreviousExpiration;
		private System.Windows.Forms.TextBox txtPreviousStatus;
		private System.Windows.Forms.Label lblPreviousStatus;
		private System.Windows.Forms.TextBox txtCurrentProduct;
		private System.Windows.Forms.Label lblCurrentProduct;
		private System.Windows.Forms.TextBox txtCurrentExpiration;
		private System.Windows.Forms.Label lblCurrentExpiration;
		private System.Windows.Forms.TextBox txtCurrentVolume;
		private System.Windows.Forms.Label lblCurrentVolume;
		private System.Windows.Forms.TextBox txtPreviousVolume;
		private System.Windows.Forms.Label lblPreviousVolume;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmInvalidateFinalStatus()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC013RemoveFinalUnitStatus;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			LoadCannedComments();

			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
		
			
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			//
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmInvalidateFinalStatus));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpCurrent = new System.Windows.Forms.GroupBox();
			this.txtCurrentVolume = new System.Windows.Forms.TextBox();
			this.lblCurrentVolume = new System.Windows.Forms.Label();
			this.txtCurrentExpiration = new System.Windows.Forms.TextBox();
			this.lblCurrentExpiration = new System.Windows.Forms.Label();
			this.txtCurrentProduct = new System.Windows.Forms.TextBox();
			this.lblCurrentProduct = new System.Windows.Forms.Label();
			this.txtCurrentStatus = new System.Windows.Forms.TextBox();
			this.lblCurrentStatus = new System.Windows.Forms.Label();
			this.lblWarning = new System.Windows.Forms.Label();
			this.btnClose = new System.Windows.Forms.Button();
			this.grpComments = new System.Windows.Forms.GroupBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblComment = new System.Windows.Forms.Label();
			this.txtDetails = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.grpPrevious = new System.Windows.Forms.GroupBox();
			this.txtPreviousVolume = new System.Windows.Forms.TextBox();
			this.lblPreviousVolume = new System.Windows.Forms.Label();
			this.txtPreviousStatus = new System.Windows.Forms.TextBox();
			this.lblPreviousStatus = new System.Windows.Forms.Label();
			this.txtPreviousProduct = new System.Windows.Forms.TextBox();
			this.lblPreviousProduct = new System.Windows.Forms.Label();
			this.txtPreviousExpiration = new System.Windows.Forms.TextBox();
			this.lblPreviousExpiration = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpCurrent.SuspendLayout();
			this.grpComments.SuspendLayout();
			this.grpPrevious.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(628, 30);
			this.vbecsLogo1.TabIndex = 7;
			this.vbecsLogo1.Title = "Remove Final Unit Status";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 407);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 9;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 68);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 320);
			this.grpImage.TabIndex = 8;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 8);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpCurrent
			// 
			this.grpCurrent.AccessibleDescription = "Current Unit Details";
			this.grpCurrent.AccessibleName = "Current Unit Details";
			this.grpCurrent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpCurrent.Controls.Add(this.txtCurrentVolume);
			this.grpCurrent.Controls.Add(this.lblCurrentVolume);
			this.grpCurrent.Controls.Add(this.txtCurrentExpiration);
			this.grpCurrent.Controls.Add(this.lblCurrentExpiration);
			this.grpCurrent.Controls.Add(this.txtCurrentProduct);
			this.grpCurrent.Controls.Add(this.lblCurrentProduct);
			this.grpCurrent.Controls.Add(this.txtCurrentStatus);
			this.grpCurrent.Controls.Add(this.lblCurrentStatus);
			this.grpCurrent.Location = new System.Drawing.Point(324, 68);
			this.grpCurrent.Name = "grpCurrent";
			this.grpCurrent.Size = new System.Drawing.Size(300, 112);
			this.grpCurrent.TabIndex = 1;
			this.grpCurrent.TabStop = false;
			this.grpCurrent.Text = "Current Unit Details";
			// 
			// txtCurrentVolume
			// 
			this.txtCurrentVolume.AccessibleDescription = "Volume Millliliters";
			this.txtCurrentVolume.AccessibleName = "Volume Millliliters";
			this.txtCurrentVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCurrentVolume.Location = new System.Drawing.Point(84, 64);
			this.txtCurrentVolume.Name = "txtCurrentVolume";
			this.txtCurrentVolume.ReadOnly = true;
			this.txtCurrentVolume.Size = new System.Drawing.Size(208, 20);
			this.txtCurrentVolume.TabIndex = 4;
			this.txtCurrentVolume.Text = "";
			// 
			// lblCurrentVolume
			// 
			this.lblCurrentVolume.Location = new System.Drawing.Point(8, 64);
			this.lblCurrentVolume.Name = "lblCurrentVolume";
			this.lblCurrentVolume.Size = new System.Drawing.Size(100, 20);
			this.lblCurrentVolume.TabIndex = 4;
			this.lblCurrentVolume.Text = "Volume (mL)";
			this.lblCurrentVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCurrentExpiration
			// 
			this.txtCurrentExpiration.AccessibleDescription = "Expiration Date";
			this.txtCurrentExpiration.AccessibleName = "Expiration Date";
			this.txtCurrentExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCurrentExpiration.Location = new System.Drawing.Point(84, 40);
			this.txtCurrentExpiration.Name = "txtCurrentExpiration";
			this.txtCurrentExpiration.ReadOnly = true;
			this.txtCurrentExpiration.Size = new System.Drawing.Size(208, 20);
			this.txtCurrentExpiration.TabIndex = 3;
			this.txtCurrentExpiration.Text = "";
			// 
			// lblCurrentExpiration
			// 
			this.lblCurrentExpiration.Location = new System.Drawing.Point(8, 40);
			this.lblCurrentExpiration.Name = "lblCurrentExpiration";
			this.lblCurrentExpiration.Size = new System.Drawing.Size(100, 20);
			this.lblCurrentExpiration.TabIndex = 2;
			this.lblCurrentExpiration.Text = "Expiration Date";
			this.lblCurrentExpiration.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCurrentProduct
			// 
			this.txtCurrentProduct.AccessibleDescription = "Product Name";
			this.txtCurrentProduct.AccessibleName = "Product Name";
			this.txtCurrentProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCurrentProduct.Location = new System.Drawing.Point(84, 16);
			this.txtCurrentProduct.Name = "txtCurrentProduct";
			this.txtCurrentProduct.ReadOnly = true;
			this.txtCurrentProduct.Size = new System.Drawing.Size(208, 20);
			this.txtCurrentProduct.TabIndex = 2;
			this.txtCurrentProduct.Text = "";
			// 
			// lblCurrentProduct
			// 
			this.lblCurrentProduct.Location = new System.Drawing.Point(8, 16);
			this.lblCurrentProduct.Name = "lblCurrentProduct";
			this.lblCurrentProduct.Size = new System.Drawing.Size(100, 20);
			this.lblCurrentProduct.TabIndex = 0;
			this.lblCurrentProduct.Text = "Product Name";
			this.lblCurrentProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCurrentStatus
			// 
			this.txtCurrentStatus.AccessibleDescription = "Unit Status";
			this.txtCurrentStatus.AccessibleName = "Unit Status";
			this.txtCurrentStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCurrentStatus.Location = new System.Drawing.Point(84, 88);
			this.txtCurrentStatus.Name = "txtCurrentStatus";
			this.txtCurrentStatus.ReadOnly = true;
			this.txtCurrentStatus.Size = new System.Drawing.Size(208, 20);
			this.txtCurrentStatus.TabIndex = 5;
			this.txtCurrentStatus.Text = "";
			// 
			// lblCurrentStatus
			// 
			this.lblCurrentStatus.Location = new System.Drawing.Point(8, 88);
			this.lblCurrentStatus.Name = "lblCurrentStatus";
			this.lblCurrentStatus.Size = new System.Drawing.Size(100, 20);
			this.lblCurrentStatus.TabIndex = 6;
			this.lblCurrentStatus.Text = "Unit Status";
			this.lblCurrentStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarning
			// 
			this.lblWarning.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarning.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblWarning.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarning.ImageAlign = System.Drawing.ContentAlignment.TopLeft;
			this.lblWarning.Location = new System.Drawing.Point(4, 34);
			this.lblWarning.Name = "lblWarning";
			this.lblWarning.Size = new System.Drawing.Size(620, 30);
			this.lblWarning.TabIndex = 6;
			this.lblWarning.Text = "WARNING: Removing a final status or a modification may have serious implications." +
				" Continue with caution.";
			this.lblWarning.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.CausesValidation = false;
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Location = new System.Drawing.Point(548, 390);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 15;
			this.btnClose.Text = "&Cancel";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// grpComments
			// 
			this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComments.Controls.Add(this.cmbComment);
			this.grpComments.Controls.Add(this.lblComment);
			this.grpComments.Controls.Add(this.txtDetails);
			this.grpComments.Controls.Add(this.lblDetails);
			this.grpComments.Enabled = false;
			this.grpComments.Location = new System.Drawing.Point(324, 304);
			this.grpComments.Name = "grpComments";
			this.grpComments.Size = new System.Drawing.Size(300, 82);
			this.grpComments.TabIndex = 11;
			this.grpComments.TabStop = false;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(84, 12);
			this.cmbComment.MaxLength = 80;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(208, 22);
			this.cmbComment.TabIndex = 12;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 12);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(60, 20);
			this.lblComment.TabIndex = 0;
			this.lblComment.Text = "Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDetails
			// 
			this.txtDetails.AccessibleDescription = "Details";
			this.txtDetails.AccessibleName = "Details";
			this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDetails.Location = new System.Drawing.Point(84, 36);
			this.txtDetails.MaxLength = 255;
			this.txtDetails.Multiline = true;
			this.txtDetails.Name = "txtDetails";
			this.txtDetails.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtDetails.Size = new System.Drawing.Size(208, 38);
			this.txtDetails.TabIndex = 13;
			this.txtDetails.Text = "";
			this.txtDetails.TextChanged += new System.EventHandler(this.txtDetails_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 36);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 2;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(468, 390);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 14;
			this.btnOK.Click += new System.EventHandler(this.btnRemoveFinalStatus_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnRemoveFinalStatus_MouseHover);
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AccessibleDescription = "Unit Search";
			this.bloodUnitSelectorVertical1.AccessibleName = "Unit Search";
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 68);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 314);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchBtnClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
			// 
			// grpPrevious
			// 
			this.grpPrevious.AccessibleDescription = "Previous Unit Details";
			this.grpPrevious.AccessibleName = "Previous Unit Details";
			this.grpPrevious.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPrevious.Controls.Add(this.txtPreviousVolume);
			this.grpPrevious.Controls.Add(this.lblPreviousVolume);
			this.grpPrevious.Controls.Add(this.txtPreviousStatus);
			this.grpPrevious.Controls.Add(this.lblPreviousStatus);
			this.grpPrevious.Controls.Add(this.txtPreviousProduct);
			this.grpPrevious.Controls.Add(this.lblPreviousProduct);
			this.grpPrevious.Controls.Add(this.txtPreviousExpiration);
			this.grpPrevious.Controls.Add(this.lblPreviousExpiration);
			this.grpPrevious.Location = new System.Drawing.Point(324, 184);
			this.grpPrevious.Name = "grpPrevious";
			this.grpPrevious.Size = new System.Drawing.Size(300, 116);
			this.grpPrevious.TabIndex = 6;
			this.grpPrevious.TabStop = false;
			this.grpPrevious.Text = "Previous Unit Details";
			// 
			// txtPreviousVolume
			// 
			this.txtPreviousVolume.AccessibleDescription = "Volume Milliliters";
			this.txtPreviousVolume.AccessibleName = "Volume Milliliters";
			this.txtPreviousVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPreviousVolume.Location = new System.Drawing.Point(84, 64);
			this.txtPreviousVolume.Name = "txtPreviousVolume";
			this.txtPreviousVolume.ReadOnly = true;
			this.txtPreviousVolume.Size = new System.Drawing.Size(208, 20);
			this.txtPreviousVolume.TabIndex = 9;
			this.txtPreviousVolume.Text = "";
			// 
			// lblPreviousVolume
			// 
			this.lblPreviousVolume.Location = new System.Drawing.Point(8, 64);
			this.lblPreviousVolume.Name = "lblPreviousVolume";
			this.lblPreviousVolume.Size = new System.Drawing.Size(100, 20);
			this.lblPreviousVolume.TabIndex = 4;
			this.lblPreviousVolume.Text = "Volume (mL)";
			this.lblPreviousVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPreviousStatus
			// 
			this.txtPreviousStatus.AccessibleDescription = "Unit Status";
			this.txtPreviousStatus.AccessibleName = "Unit Status";
			this.txtPreviousStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPreviousStatus.Location = new System.Drawing.Point(84, 88);
			this.txtPreviousStatus.Name = "txtPreviousStatus";
			this.txtPreviousStatus.ReadOnly = true;
			this.txtPreviousStatus.Size = new System.Drawing.Size(208, 20);
			this.txtPreviousStatus.TabIndex = 10;
			this.txtPreviousStatus.Text = "";
			// 
			// lblPreviousStatus
			// 
			this.lblPreviousStatus.Location = new System.Drawing.Point(8, 88);
			this.lblPreviousStatus.Name = "lblPreviousStatus";
			this.lblPreviousStatus.Size = new System.Drawing.Size(100, 20);
			this.lblPreviousStatus.TabIndex = 6;
			this.lblPreviousStatus.Text = "Unit Status";
			this.lblPreviousStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPreviousProduct
			// 
			this.txtPreviousProduct.AccessibleDescription = "Product Name";
			this.txtPreviousProduct.AccessibleName = "Product Name";
			this.txtPreviousProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPreviousProduct.Location = new System.Drawing.Point(84, 16);
			this.txtPreviousProduct.Name = "txtPreviousProduct";
			this.txtPreviousProduct.ReadOnly = true;
			this.txtPreviousProduct.Size = new System.Drawing.Size(208, 20);
			this.txtPreviousProduct.TabIndex = 7;
			this.txtPreviousProduct.Text = "";
			// 
			// lblPreviousProduct
			// 
			this.lblPreviousProduct.Location = new System.Drawing.Point(8, 16);
			this.lblPreviousProduct.Name = "lblPreviousProduct";
			this.lblPreviousProduct.Size = new System.Drawing.Size(100, 20);
			this.lblPreviousProduct.TabIndex = 0;
			this.lblPreviousProduct.Text = "Product Name";
			this.lblPreviousProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPreviousExpiration
			// 
			this.txtPreviousExpiration.AccessibleDescription = "Expiration Date";
			this.txtPreviousExpiration.AccessibleName = "Expiration Date";
			this.txtPreviousExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPreviousExpiration.Location = new System.Drawing.Point(84, 40);
			this.txtPreviousExpiration.Name = "txtPreviousExpiration";
			this.txtPreviousExpiration.ReadOnly = true;
			this.txtPreviousExpiration.Size = new System.Drawing.Size(208, 20);
			this.txtPreviousExpiration.TabIndex = 8;
			this.txtPreviousExpiration.Text = "";
			// 
			// lblPreviousExpiration
			// 
			this.lblPreviousExpiration.Location = new System.Drawing.Point(8, 40);
			this.lblPreviousExpiration.Name = "lblPreviousExpiration";
			this.lblPreviousExpiration.Size = new System.Drawing.Size(100, 20);
			this.lblPreviousExpiration.TabIndex = 2;
			this.lblPreviousExpiration.Text = "Expiration Date";
			this.lblPreviousExpiration.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// FrmInvalidateFinalStatus
			// 
			this.AcceptButton = this.btnOK;
			this.AccessibleDescription = "WARNING: Removing a final status or a modification may have serious implications." +
				" Continue with caution.";
			this.AccessibleName = "WARNING: Removing a final status or a modification may have serious implications." +
				" Continue with caution.";
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnClose;
			this.ClientSize = new System.Drawing.Size(628, 423);
			this.Controls.Add(this.grpPrevious);
			this.Controls.Add(this.bloodUnitSelectorVertical1);
			this.Controls.Add(this.grpComments);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.grpCurrent);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.lblWarning);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Remove_Final_Status.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(636, 450);
			this.Name = "FrmInvalidateFinalStatus";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Remove Final Unit Status";
			this.Load += new System.EventHandler(this.FrmInvalidateFinalStatus_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmInvalidateFinalStatus_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.lblWarning, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpCurrent, 0);
			this.Controls.SetChildIndex(this.btnClose, 0);
			this.Controls.SetChildIndex(this.grpComments, 0);
			this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
			this.Controls.SetChildIndex(this.grpPrevious, 0);
			this.grpImage.ResumeLayout(false);
			this.grpCurrent.ResumeLayout(false);
			this.grpComments.ResumeLayout(false);
			this.grpPrevious.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Comment
		/// Implements BR_13.02
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbComment.SelectedIndex>-1)
				{
					if (this.cmbComment.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbComment.Text;
					}
					if (this.txtDetails.Text.Trim().Length > 0)
					{
						if ((comment.Length > 0) && (comment[comment.Length - 1] != '.'))
						{
							comment = string.Concat(comment, ". ");
						}
						comment = string.Concat(comment, this.txtDetails.Text);
					}
				}
				return comment;
			}
		}

		/// <summary>
		/// BloodUnit
		/// </summary>
		public BOL.BloodUnit BloodUnit
		{
			get
			{
				return this._bloodUnit;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// Implements BR_13.01
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Remove Final Unit Status or Modification";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC013.FrmInvalidateFinalStatus());
			//
			//BR_13.01
			this.lblWarning.Text = Common.StrRes.InfoMsg.UC013.WarningMessage().ResString;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.SetThisToolTip(this.txtPreviousStatus, Common.StrRes.Tooltips.UC013.PreviousUnitStatus());
			this.SetThisToolTip(this.txtCurrentStatus, Common.StrRes.Tooltips.UC013.CurrentUnitStatus());
			this.SetThisToolTip(this.cmbComment, Common.StrRes.Tooltips.Common.CommentRequired());
			this.SetThisToolTip(this.txtDetails, Common.StrRes.Tooltips.Common.CommentRequiredWithOther());
			this.SetThisToolTip(this.btnClose, Common.StrRes.Tooltips.Common.Cancel());
		}

		private void LoadCannedComments()
		{
			_dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"UY");
			//
			this.cmbComment.Items.Clear();
			foreach(DataRow dr in _dtComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		private void ClearControls()
		{
			this.txtDetails.Text = "";
			this.cmbComment.SelectedIndex = -1;
			this.grpComments.Enabled = false;
			this.txtCurrentExpiration.Text = "";
			this.txtCurrentProduct.Text = "";
			this.txtCurrentStatus.Text = "";
			this.txtCurrentVolume.Text = "";
			this.txtPreviousExpiration.Text = "";
			this.txtPreviousProduct.Text = "";
			this.txtPreviousStatus.Text = "";
			this.txtPreviousVolume.Text = "";
			//
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = false;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = false;
		}

		private void PopulateControls()
		{
			this.txtDetails.Text = "";
			this.cmbComment.SelectedIndex = -1;
			this.grpComments.Enabled = true;
			//
			this.txtCurrentExpiration.Text = Common.VBECSDateTime.FormatDateTimeString(this._bloodUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtCurrentProduct.Text = string.Concat(this._bloodUnit.ProductCode, " - ", this._bloodUnit.ProductShortName);
			this.txtCurrentVolume.Text = this._bloodUnit.OriginalVolume.ToString();
			this.txtCurrentStatus.Text = this._bloodUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			//
			this.txtPreviousExpiration.Text = Common.VBECSDateTime.FormatDateTimeString(this._previousUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtPreviousProduct.Text = string.Concat(this._previousUnit.ProductCode, " - ", this._previousUnit.ProductShortName);
			this.txtPreviousVolume.Text = this._previousUnit.OriginalVolume.ToString();
			//
			if (this._bloodUnit.BloodUnitStatus.IsFinal())
			{
				string previousStatus = this._previousUnitStatus;
				if (this._bloodUnit.BloodUnitStatus.QuarantineIndicator)
				{
					previousStatus = string.Concat(previousStatus, " (Quarantined)");
				}
				if (this._bloodUnit.BloodUnitStatus.BiohazardousWarningIndicator)
				{
					previousStatus = string.Concat(previousStatus, " (Biohazardous)");
				}
				this.txtPreviousStatus.Text = previousStatus;
			}
			else
			{
				this.txtPreviousStatus.Text = this._previousUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			}
			//
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = true;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = true;
		}

		/// <summary>
		/// Get selected blood unit
		/// Implements BR_13.04
		/// </summary>
		private void GetBloodUnit()
		{
			//Create the new bloodunit
			if (this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitStatus.IsFinal())
			{
				this._bloodUnit = this.bloodUnitSelectorVertical1.SelectedBloodUnit;
				//
				string childUnits = this._bloodUnit.GetChildBloodUnitMessageString(this._bloodUnit.BloodUnitGuid);
				//
				if (childUnits.Trim().Length == 0)
				{
					this._previousUnit = new BOL.BloodUnit(this._bloodUnit.BloodUnitGuid,this._bloodUnit.BloodProductGuid);
					//
					object[] unitStatus = this._bloodUnit.GetPreviousBloodUnitStatusTextAndCodeByGuid(this._bloodUnit.BloodUnitGuid);
					//
					if ((unitStatus.Length == 2) && (unitStatus[0] != null) && (unitStatus[1] != null))
					{
						//Can't change unit status code because its read-only
						this._previousUnitStatusCode = (Common.UnitStatusCode)unitStatus[1];
						this._previousUnitStatus = unitStatus[0].ToString();
					}
					else
					{
						throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.UC013.NoPreviousStatus().ResString);
					}
				}
				else
				{
					throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.UC013.UnitHasActiveChildren(childUnits).ResString);
				}
			}
			else
			{
				//Create the new bloodunit
				DataTable dtBloodUnitModification = BOL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
				//
				if (dtBloodUnitModification.Rows.Count>0)
				{
					this._bloodUnit = this.bloodUnitSelectorVertical1.SelectedBloodUnit;
					//
					// BR_11.04
					if (BOL.OutgoingShipmentCollection.IsBloodUnitOnPendingOutgoingShipment(this._bloodUnit.BloodUnitGuid))
					{
						throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.UC011.UnitOnPendingShipment().ResString);
					}
					//
					// BR_70.03
					DataTable dtOrders = BOL.OrderedUnit.GetOrderedUnit(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
					if (dtOrders.Rows.Count == 0)
					{
						this._bloodUnitModification = dtBloodUnitModification.Rows[0];
						//
						this._previousUnit = new BOL.BloodUnit(this._bloodUnit.BloodUnitGuid,this._bloodUnit.BloodProductGuid);
						this._previousUnit.OriginalVolume = Convert.ToDecimal(this._bloodUnitModification[Common.VbecsTables.BloodUnitModification.FromOriginalVolume]);
						this._previousUnit.BloodProductGuid = (Guid)this._bloodUnitModification[Common.VbecsTables.BloodUnitModification.FromBloodProductGuid];
						this._previousUnit.ProductCode = this._bloodUnitModification[Common.VbecsTables.BloodProduct.ProductCode].ToString();
						this._previousUnit.ProductShortName = this._bloodUnitModification[Common.VbecsTables.BloodProduct.ProductShortName].ToString();
						this._previousUnit.BloodUnitMedia.UnitExpirationDate = Convert.ToDateTime(this._bloodUnitModification[Common.VbecsTables.BloodUnitModification.FromUnitExpirationDate]);
					}
					else
					{
						throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.UC070.CannotInactivateUnit().ResString);
					}
				}
				else
				{
					//BR_13.04
					throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.UC013.UnitNotInFinalStatus().ResString);
				}
			}
		}

		private void CheckIfDetailsRequired()
		{
			//Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		private void CheckValid()
		{
			if (_detailsRequired)
			{
				btnOK.EnabledButton = (this.txtDetails.Text.Trim().Length > 0);
			}
			else
			{
				btnOK.EnabledButton = (this.cmbComment.SelectedIndex > -1);
			}
		}

		
		private DataTable GetModificationsToInvalidate()
		{
			DataTable dtMods = BOL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(this._bloodUnit.BloodUnitGuid);
			//
			DataTable returnTable = dtMods.Clone();
			//
			foreach(DataRow drMod in dtMods.Rows)
			{
				//Only include pool or split mods where the Guid changed
				if (drMod[Common.VbecsTables.BloodUnitModification.FromBloodUnitGuid] != drMod[Common.VbecsTables.BloodUnitModification.ToBloodUnitGuid])
				{
					returnTable.Rows.Add(drMod.ItemArray);
				}
			}
			//
			return returnTable;
		}

		#endregion

		#region ControlEvents

		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.UnlockAllRecords();
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			this.ClearControls();
			
			//Setting the isdirty variable to false
			this.IsDirty=false;
		}

		private void bloodUnitSelectorVertical1_SearchBtnClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();
					//
					//Get units that were modified (except for pools and splits)
					System.Data.DataTable eligDt = BOL.BloodUnit.GetModifiedBloodUnits();
					//Get units in a final status
					System.Data.DataTable eligDt2 = BOL.BloodUnit.GetBloodUnitsInFinalStatus(ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator);
					//Combine the two lists...
					foreach(DataRow dr in eligDt2.Rows)
					{
						eligDt.Rows.Add(dr.ItemArray);
					}
					//
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Unit in Final Status or Modified Unit";
					unitSelector.LogoBarText = "Select Unit in Final Status or Modified Unit";
					unitSelector.ShowDialogFromLockedParent(this, false);
					//
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this.Refresh();
						System.Data.DataRow dr = unitSelector.SelectedUnits.Rows[0];

						this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
				}
			}
		}

		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			try
			{
				this.GetBloodUnit();

				if (!this.SetLocks(this._bloodUnit.BloodUnitGuid, this._bloodUnit.BloodUnitStatus.BloodUnitStatusGuid, this._bloodUnit.BloodUnitFinance.BloodUnitFinanceGuid ))
					return;

				if (this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transfused)
				{
					this._patientTransfusion = new BOL.PatientTransfusion(this._bloodUnit.BloodUnitGuid);

				}

				this.PopulateControls();
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
				this.ClearControls();
			}
		}

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnRemoveFinalStatus_Click(object sender, System.EventArgs e)
		{
			Common.WorkloadProcessID workloadProcessId = Common.WorkloadProcessID.Unknown;

			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("blood unit"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					System.Data.DataTable dt = null;
					bool success = false;
					//
					DataTable dtBCEMessages = null;
					DataTable dtTempBCEMessages = null;

					//CR 2941
					//CR 2945
					//generate table with BCE_MESSAGE
					//The Unit is returned from final status, send BCE message

					//sending a reserve message if blood unit is in Assigned or Crossmatched status after return from final status
					if (this._previousUnitStatusCode == Common.UnitStatusCode.Assigned ||
						this._previousUnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned)
					{
						//getting all patients assigned to a unit
						DataTable dtPatients = BOL.PatientAssignments.GetPatientsAssignmentDetails(this._previousUnit.BloodUnitGuid);
						Guid patientGuid = Guid.Empty;

						for (int j=0; j< dtPatients.Rows.Count; j++)
						{
							patientGuid = (Guid)dtPatients.Rows[j][Common.VbecsTables.Patient.PatientGuid];
							//CR 3015
							BOL.OrderedUnit orderedUnit = new BOL.OrderedUnit(this._previousUnit.BloodUnitGuid, patientGuid);

							if (dtBCEMessages == null)
							{
								dtBCEMessages = BOL.OrderedUnit.UpdateBce(this._previousUnit.BloodUnitGuid, patientGuid, orderedUnit.OrderedComponentGuid, "", Common.HL7BPDispenseStatus.RS, false);
							}
							else
							{
								dtTempBCEMessages = BOL.OrderedUnit.UpdateBce(this._previousUnit.BloodUnitGuid, patientGuid, orderedUnit.OrderedComponentGuid, "", Common.HL7BPDispenseStatus.RS, false);
								if (dtTempBCEMessages.Rows.Count > 0)
									dtBCEMessages.Rows.Add(dtTempBCEMessages.Rows[0].ItemArray);
							}

						}
					}
						//sending a disposition message if blood unit is in Issued status after return from final status
					else if (this._previousUnitStatusCode == Common.UnitStatusCode.Issued)
					{
						//getting all patients assigned to a unit
						DataTable dtPatients = BOL.PatientAssignments.GetPatientsAssignmentDetails(this._previousUnit.BloodUnitGuid);
						Guid patientGuid = Guid.Empty;

						for (int j=0; j< dtPatients.Rows.Count; j++)
						{
							patientGuid = (Guid)dtPatients.Rows[j][Common.VbecsTables.Patient.PatientGuid];
							//CR 3015
							BOL.OrderedUnit orderedUnit = new BOL.OrderedUnit(this._previousUnit.BloodUnitGuid, patientGuid);
							BOL.IssuedUnit issuedUnit = BOL.IssuedUnit.GetIssuedUnitFromBloodUnitGuid(this._previousUnit.BloodUnitGuid);
							
							if (dtBCEMessages == null)
							{
								dtBCEMessages = BOL.OrderedUnit.UpdateBce(this._previousUnit.BloodUnitGuid, patientGuid, orderedUnit.OrderedComponentGuid, issuedUnit.IssueToLocationName, Common.HL7BPDispenseStatus.DS, false);
							}
							else
							{
								dtTempBCEMessages = BOL.OrderedUnit.UpdateBce(this._previousUnit.BloodUnitGuid, patientGuid, orderedUnit.OrderedComponentGuid, issuedUnit.IssueToLocationName, Common.HL7BPDispenseStatus.DS, false);
								if (dtTempBCEMessages.Rows.Count > 0)
									dtBCEMessages.Rows.Add(dtTempBCEMessages.Rows[0].ItemArray);
							}
						}
					}

					//BCE_MESSAGE end
					
					if (this._bloodUnit.BloodUnitStatus.IsFinal())
					{
						//
						if (this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transfused)
						{
							workloadProcessId = Common.WorkloadProcessID.TransfuseUnit;
							
							success = this._bloodUnit.RemoveFinalStatus(this.Comment, this._patientTransfusion, workloadProcessId, dtBCEMessages);
						}
						else if (this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transferred)
						{
							DataTable dtOutgoingShipment = BOL.OutgoingShipmentCollection.GetOutgoingBloodUnitShipment(this._bloodUnit.BloodUnitGuid);
							workloadProcessId = Common.WorkloadProcessID.UnitLogout;
							success = this._bloodUnit.RemoveFinalStatus(this.Comment, dtOutgoingShipment, workloadProcessId, dtBCEMessages);
						}
						else if (this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Modified)
						{
							DataTable dtBloodUnitModification = GetModificationsToInvalidate();
							if (dtBloodUnitModification.Rows.Count > 0)
							{
								if (dtBloodUnitModification.Rows[0][Common.VbecsTables.BloodUnitModification.ProductModificationCode].ToString().Trim() ==
									Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult).ToString())
								{
									workloadProcessId = Common.WorkloadProcessID.SplitUnit;
								}
							}
							success = this._bloodUnit.RemoveFinalStatus(this.Comment, workloadProcessId, dtBloodUnitModification, dtBCEMessages);
						}
						else if(this._bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Discarded)
						{
							workloadProcessId = Common.WorkloadProcessID.DiscardUnit;
							success = this._bloodUnit.RemoveFinalStatus(this.Comment, workloadProcessId, dtBCEMessages);
						}
					}
					else
					{
						
						success = this._bloodUnit.RemoveUnitModification(this._bloodUnitModification, this.Comment, ref workloadProcessId, dtBCEMessages);
					}
					//
					if (success)
					{
						//CR 1441
						dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) workloadProcessId);
						if(dt!= null && workloadProcessId != Common.WorkloadProcessID.Unknown)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}

						this.IsDirty = false;
						this.Close();
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("blood unit"));
						return;
					}
				}
				catch(Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
				
			}
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
			//
			if (cmbComment.SelectedIndex>-1)
			{
				this.SetDirtyFlag(sender,e);
			}
		}

		private void txtDetails_TextChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
			//
			if (txtDetails.Text.Trim().Length>0)
			{
				this.SetDirtyFlag(sender,e);
			}
		}

		private void btnRemoveFinalStatus_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else if (this._bloodUnit != null)
			{
				// **** 508 Compliance ***
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.EnterAComment().ResString);
			}
			else
			{
				// **** 508 Compliance ***
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectBloodUnit().ResString);
			}
		}

		private void FrmInvalidateFinalStatus_Load(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmInvalidateFinalStatus_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			// 
			if (!this.btnOK.EnabledButton && this._bloodUnit == null)
			{
				textToSpeak = Common.StrRes.Tooltips.Common.SelectBloodUnit().ResString;
			}
			else if (!this.btnOK.EnabledButton && this._bloodUnit != null)
			{
				textToSpeak = Common.StrRes.Tooltips.Common.EnterAComment().ResString;
			}
			//
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.bloodUnitSelectorVertical1.GetErrorMessages();

			this.SpeakMessage( textToSpeak );
		}

		#endregion
	}
}

